<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('order_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('order_id')->constrained('orders')->onDelete('cascade');
            $table->foreignId('product_id')->constrained('products')->onDelete('cascade');

            // Pricing Snapshot
            $table->enum('price_type', ['tp', 'flat'])->default('tp'); // TP = Trade Price
            $table->decimal('unit_price', 10, 2);

            // Quantities
            $table->integer('quantity');
            $table->integer('bonus_quantity')->default(0); // Free items

            $table->decimal('total_price', 10, 2); // (quantity * unit_price)
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('order_items');
    }
};
