"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = filter;

function filter(values, test) {
  if (typeof test !== "function") throw new TypeError("test is not a function");
  const array = [];
  let index = -1;

  for (const value of values) {
    if (test(value, ++index, values)) {
      array.push(value);
    }
  }

  return array;
}